package com.ejie.aa17a.control;

import java.util.Date;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.aa17a.model.Aa17aDatoHorario;
import com.ejie.aa17a.service.iface.Aa17aDatoHorarioService;
import com.ejie.aa17a.utilidades.Aa17aConstantes;
import com.ejie.aa17a.utilidades.Aa17aFuncionesComunes;

/**
 * Aa17aDatoHorarioController generated by UDA, 18-dic-2013 15:36:30.
 * 
 * @author UDA
 */

@RequestMapping(value = "/datohorario")
public class Aa17aDatoHorarioController {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa17aDatoHorarioController.class);

	private Aa17aDatoHorarioService aa17aDatoHorarioService;

	/**
	 * Method 'getCreateForm'
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "contaminante", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		Aa17aDatoHorarioController.logger
				.info("[GET - View] : aa17adatohorario");

		model.addAttribute("fechaActual", Aa17aFuncionesComunes.formatearFecha(new Date(), LocaleContextHolder.getLocale()));

		//formatos de exportacion
		model.addAttribute("formato_xls", Aa17aConstantes.EXPORTAR_FORMATO_EXCEL);
		model.addAttribute("formato_pdf", Aa17aConstantes.EXPORTAR_FORMATO_PDF);
		model.addAttribute("formato_csv", Aa17aConstantes.EXPORTAR_FORMATO_CSV);

		return new ModelAndView("datohorario", "model", model);
	}

	/**
	 * Method 'getCreateForm'
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "comparativa", method = RequestMethod.GET)
	public ModelAndView getCreateFormComparativa(Model model) {
		Aa17aDatoHorarioController.logger
				.info("[GET - View] : aa17adatohorario");

		//return "datohorario";
		model.addAttribute("fechaActual", Aa17aFuncionesComunes.formatearFecha(new Date(), LocaleContextHolder.getLocale()));
		//formatos de exportacion
		model.addAttribute("formato_xls", Aa17aConstantes.EXPORTAR_FORMATO_EXCEL);
		model.addAttribute("formato_pdf", Aa17aConstantes.EXPORTAR_FORMATO_PDF);
		model.addAttribute("formato_csv", Aa17aConstantes.EXPORTAR_FORMATO_CSV);

		return new ModelAndView("datohorariocomparativa", "model", model);
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterAa17aDatoHorario
	 *            Aa17aDatoHorario
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	List<Aa17aDatoHorario> getAll(
			@RequestBody Aa17aDatoHorario filterAa17aDatoHorario) {
		Aa17aDatoHorarioController.logger
				.info("[GET - find_ALL] : Obtener Aa17aDatoHorario por filtro" + filterAa17aDatoHorario.getIdEstacion());

		return this.aa17aDatoHorarioService.findAll(filterAa17aDatoHorario);
	}

	/**
	 * Method 'setAa17aDatoHorarioService'.
	 * 
	 * @param aa17aDatoHorarioService
	 *            Aa17aDatoHorarioService
	 * @return
	 */
	public void setAa17aDatoHorarioService(
			Aa17aDatoHorarioService aa17aDatoHorarioService) {
		this.aa17aDatoHorarioService = aa17aDatoHorarioService;
	}
}
